<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Test Checkout - ReviewPR</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
</head>
<body class="bg-gray-50 p-8">
    <div class="max-w-md mx-auto bg-white rounded-lg shadow-lg p-6">
        <h2 class="text-2xl font-bold mb-6 text-center">Quick Checkout Test</h2>
        
        <div id="result" class="mb-4 p-4 rounded-lg hidden"></div>
        
        <button onclick="testOrder()" class="w-full bg-blue-600 text-white py-3 rounded-lg hover:bg-blue-700 mb-4">
            Test Order Creation
        </button>
        
        <div class="text-center space-y-2">
            <a href="simple-checkout.php?service=Google%20Reviews%20Package&price=49.99" class="block bg-green-600 text-white py-2 px-4 rounded hover:bg-green-700">
                Full Checkout Form
            </a>
            <a href="admin_dashboard.php" class="block bg-purple-600 text-white py-2 px-4 rounded hover:bg-purple-700">
                View Admin Panel
            </a>
        </div>
    </div>

    <script>
        function testOrder() {
            const resultDiv = document.getElementById('result');
            resultDiv.className = 'mb-4 p-4 rounded-lg bg-blue-100 text-blue-800';
            resultDiv.innerHTML = '⏳ Testing order creation...';
            resultDiv.classList.remove('hidden');
            
            const testData = {
                productId: 1,
                productName: 'Test Google Reviews Package',
                price: 49.99,
                quantity: 1,
                total: 49.99,
                customerEmail: 'test@example.com',
                customerName: 'Test Customer',
                reviewLocation: 'Test Business Location',
                reviewsPerDay: 2,
                customerNotes: 'This is a test order to verify the system works',
                promoCode: '',
                fileName: '',
                fileLink: ''
            };
            
            console.log('Sending test data:', testData);
            
            fetch('debug_order.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify(testData)
            })
            .then(response => {
                console.log('Response status:', response.status);
                console.log('Response headers:', response.headers);
                return response.text();
            })
            .then(text => {
                console.log('Raw response:', text);
                try {
                    const data = JSON.parse(text);
                    console.log('Parsed response:', data);
                    
                    if (data.success) {
                        resultDiv.className = 'mb-4 p-4 rounded-lg bg-green-100 text-green-800';
                        resultDiv.innerHTML = `
                            <h3 class="font-bold">✅ Success!</h3>
                            <p>Order ID: ${data.orderId}</p>
                            <p>The checkout system is working perfectly!</p>
                            <p class="text-sm mt-2">Check the admin panel to see your test order.</p>
                        `;
                    } else {
                        resultDiv.className = 'mb-4 p-4 rounded-lg bg-red-100 text-red-800';
                        resultDiv.innerHTML = `
                            <h3 class="font-bold">❌ Error</h3>
                            <p>Error: ${data.error || 'Unknown error'}</p>
                            <details class="mt-2">
                                <summary class="cursor-pointer">Debug Info</summary>
                                <pre class="text-xs mt-2 bg-gray-100 p-2 rounded">${JSON.stringify(data, null, 2)}</pre>
                            </details>
                        `;
                    }
                } catch (e) {
                    console.error('JSON parse error:', e);
                    resultDiv.className = 'mb-4 p-4 rounded-lg bg-red-100 text-red-800';
                    resultDiv.innerHTML = `
                        <h3 class="font-bold">❌ Parse Error</h3>
                        <p>Could not parse server response</p>
                        <details class="mt-2">
                            <summary class="cursor-pointer">Raw Response</summary>
                            <pre class="text-xs mt-2 bg-gray-100 p-2 rounded">${text}</pre>
                        </details>
                    `;
                }
            })
            .catch(error => {
                console.error('Fetch error:', error);
                resultDiv.className = 'mb-4 p-4 rounded-lg bg-red-100 text-red-800';
                resultDiv.innerHTML = `
                    <h3 class="font-bold">❌ Network Error</h3>
                    <p>Error: ${error.message}</p>
                    <p class="text-sm mt-2">Check browser console for details.</p>
                `;
            });
        }
    </script>
</body>
</html>
